/******************************************************************************
 *  Do not modify this file!
 *  This file is auto-generated.
 *  Any changes will be lost.
 *  This interface is defined in model.xml
 ******************************************************************************/

#include "csfunified/services/impl/base/MeetingBaseImpl.h"
#include "csfunified/services/impl/notifiers/MeetingNotifiersImpl.h"
#ifdef major
	#undef major
#endif
#ifdef minor
	#undef minor
#endif


namespace CSFUnified
{
    const std::string MeetingBaseImpl::className = "MeetingBaseImpl";

    void MeetingBaseImpl::initNotifiers()
    {
        if(!notifiers)
        {
            this->notifiers.reset(new MeetingNotifiersImpl());
            this->addObserver(SMART_PTR_NS::weak_ptr<MeetingObserver>(SMART_PTR_NS::dynamic_pointer_cast<MeetingObserver>(this->notifiers)));
        }
    }
        
    std::string MeetingBaseImpl::getGuid() 
    {
        return UnifiedBusinessObjectImpl::getGuid();
    }

    std::string MeetingBaseImpl::getName()
    {
        EnsureUpdateAccess();
        return this->name;
    }

    void MeetingBaseImpl::setName(const std::string & update)
    {
        EnsureUpdateAccess();
        // Suppress firing when no real change occurs
        std::string preUpdate = this->name;
        this->name = update;
        if ( preUpdate != this->name) 
        {
            MeetingBaseImpl::fireName();
        }
    }
 SMART_PTR_NS::shared_ptr< std::vector< SMART_PTR_NS::shared_ptr<MeetingParticipant> > > MeetingBaseImpl::getParticipants()
    {
        EnsureUpdateAccess();
        return this->participants;
    }

    void MeetingBaseImpl::setParticipants(SMART_PTR_NS::shared_ptr< std::vector< SMART_PTR_NS::shared_ptr<MeetingParticipant> > > update)
    {
        EnsureUpdateAccess();
        // Suppress firing when no real change occurs
        SMART_PTR_NS::shared_ptr< std::vector< SMART_PTR_NS::shared_ptr<MeetingParticipant> > > preUpdate = this->participants;
        this->participants = update;
        if ( preUpdate != this->participants) 
        {
            MeetingBaseImpl::fireParticipants(update, this->participants);
        }
    }
 

    MeetingBaseImpl::MeetingBaseImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory)
        : UnifiedBusinessObjectImpl(unifiedFactory, MeetingBaseImpl::className),
          name(),
          participants(new std::vector< SMART_PTR_NS::shared_ptr<MeetingParticipant> >())
    {
    }
    
    MeetingBaseImpl::MeetingBaseImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory, bool offServicesDispatcher)
        : UnifiedBusinessObjectImpl(unifiedFactory, offServicesDispatcher, MeetingBaseImpl::className),
          name(),
          participants(new std::vector< SMART_PTR_NS::shared_ptr<MeetingParticipant> >())
    {
    }

    void MeetingBaseImpl::addObserver(SMART_PTR_NS::weak_ptr<MeetingObserver> observer)
    {
        UnifiedBusinessObjectImpl::addObserver(observer);
    }

    void MeetingBaseImpl::removeObserver(SMART_PTR_NS::weak_ptr<MeetingObserver> observer)
    {
        UnifiedBusinessObjectImpl::removeObserver(observer);
    }
        
    SMART_PTR_NS::shared_ptr<MeetingNotifiers> MeetingBaseImpl::getMeetingNotifiers()
    {
        initNotifiers();
        return SMART_PTR_NS::dynamic_pointer_cast<MeetingNotifiers>(notifiers);
    }
        
    
  
    
    void MeetingBaseImpl::fireName()
    {
        EnsureUpdateAccess();
        ObserverPtrVtr<MeetingObserver>::Type observers = getFilteredObservers<MeetingObserver>();
        for (size_t i=0; i!=observers.size(); i++)
        {
            observers[i]->OnNameChanged();
        }
    }
    
    void MeetingBaseImpl::fireParticipants(SMART_PTR_NS::shared_ptr<std::vector<SMART_PTR_NS::shared_ptr<MeetingParticipant> > > added, SMART_PTR_NS::shared_ptr<std::vector<SMART_PTR_NS::shared_ptr<MeetingParticipant> > > removed)
    {
        EnsureUpdateAccess();
        ObserverPtrVtr<MeetingObserver>::Type observers = getFilteredObservers<MeetingObserver>();
        for (size_t i=0; i!=observers.size(); i++)
        {
            observers[i]->OnParticipantsChanged(added, removed);
        }
    }


}